/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.validacion.esquema.xsl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

public class XslConverter {
    private File archivoXML;
    private File resultFile;
    private String rutaXSLT;

    public XslConverter(File archivoXML, String rutaXSLT, File resultFile) {
        this.archivoXML = archivoXML;
        this.rutaXSLT = rutaXSLT;
        this.resultFile = resultFile;
    }

    public void convert() throws Exception {
        FileInputStream fileSource = new FileInputStream(this.archivoXML);
        InputStream templateFile = XslConverter.class.getResourceAsStream(this.rutaXSLT);
        TransformerFactory transformerFactory = SAXTransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(new StreamSource(templateFile));
        StreamSource s = new StreamSource(fileSource);
        StreamResult r = new StreamResult(this.resultFile);
        transformer.transform(s, r);
    }

    public void convertWithChainFilter(List<String> xslFilters) throws FileNotFoundException, ParserConfigurationException, SAXException, TransformerException {
        ArrayList<XMLFilter> filtros = new ArrayList<XMLFilter>();
        FileInputStream fileSource = new FileInputStream(this.archivoXML);
        BufferedInputStream bis = new BufferedInputStream(fileSource);
        InputSource input = new InputSource(bis);
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        SAXParser parser = spf.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        TransformerFactory transformerFactory = SAXTransformerFactory.newInstance();
        int numeroDeFiltros = xslFilters.size();
        if (numeroDeFiltros >= 1) {
            InputStream templateFile = XslConverter.class.getResourceAsStream(xslFilters.get(0));
            XMLFilter filter1 = ((SAXTransformerFactory)transformerFactory).newXMLFilter(new StreamSource(templateFile));
            filter1.setParent(reader);
            filtros.add(0, filter1);
            int i = 1;
            while (i < numeroDeFiltros) {
                templateFile = XslConverter.class.getResourceAsStream(xslFilters.get(i));
                XMLFilter filter = ((SAXTransformerFactory)transformerFactory).newXMLFilter(new StreamSource(templateFile));
                filter.setParent((XMLReader)filtros.get(i - 1));
                filtros.add(i, filter);
                ++i;
            }
        }
        Transformer transformer = transformerFactory.newTransformer();
        SAXSource transformSource = new SAXSource((XMLReader)filtros.get(numeroDeFiltros - 1), input);
        StreamResult result = new StreamResult(this.resultFile);
        transformer.transform(transformSource, result);
    }
}

